#!/bin/bash
# $Header: /home/cvs/rootbin/mbrpartdumper.sh,v 1.1 2022/01/06 10:45:14 ralph Exp $
echo "Linux MBR and Partition Dumping Helper - @(#) $Id: mbrpartdumper.sh,v 1.1 2022/01/06 10:45:14 ralph Exp $"

# Linux, root?
if [ $EUID -ne 0 ]; then
  echo $0": Error this tool must be run as root!"
  exit 1
fi

MBR=$(fdisk -l|grep ^Disk|grep /dev/ |grep -v /dev/loop|tr -d ":"|awk '{ print $2; }')
PART=$(fdisk -l| grep ^/dev/|awk '{print $1;}')

# -----------------------------------------------------------------------------

for i in ${MBR}
do
	echo "MBR: " ${i}
	FN=$(echo ${i} | awk -F/ '{print $NF;}')
	dd if=${i} of=${FN}_mbr.img bs=8k count=1  2>&1 | grep -v " records "
done
for i in ${PART}
do
	echo "Partition: " ${i}
	FN=$(echo ${i} | awk -F/ '{print $NF;}')
	dd if=${i} of=${FN}_part.img bs=8k count=1 2>&1  | grep -v " records "
done
sync


