/* Version: 1.0.27 - December 27, 2022 11:18:00 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.dpay = {}));
})(this, (function (exports) { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	var nbpeer_min = {exports: {}};

	var localStorage$1 = {exports: {}};

	// http://www.rajdeepd.com/articles/chrome/localstrg/LocalStorageSample.htm

	// NOTE:
	// this varies from actual localStorage in some subtle ways

	// also, there is no persistence
	// TODO persist
	(function () {

	  var db;
	  function LocalStorage() {}
	  db = LocalStorage;
	  db.prototype.getItem = function (key) {
	    if (this.hasOwnProperty(key)) {
	      return String(this[key]);
	    }
	    return null;
	  };
	  db.prototype.setItem = function (key, val) {
	    this[key] = String(val);
	  };
	  db.prototype.removeItem = function (key) {
	    delete this[key];
	  };
	  db.prototype.clear = function () {
	    var self = this;
	    Object.keys(self).forEach(function (key) {
	      self[key] = undefined;
	      delete self[key];
	    });
	  };
	  db.prototype.key = function (i) {
	    i = i || 0;
	    return Object.keys(this)[i];
	  };
	  db.prototype.__defineGetter__('length', function () {
	    return Object.keys(this).length;
	  });
	  if (commonjsGlobal.localStorage) {
	    localStorage$1.exports = localStorage;
	  } else {
	    localStorage$1.exports = new LocalStorage();
	  }
	})();

	/* Version: 1.0.53 - December 27, 2022 11:15:11 */

	(function (module, exports) {
	(function (global, factory) {
	  module.exports = factory() ;
	})(commonjsGlobal, function () {

	  var isBrowser = isBrowser || new Function('try {return this===window;}catch(e){ return false;}');
	  var io, eccryptoJS;
	  const g_isBrowser = isBrowser();
	  let g_initLib = false;
	  const fromHexString = hexString => Uint8Array.from(hexString.match(/.{1,2}/g).map(byte => parseInt(byte, 16)));
	  function decodeEnc(encObj) {
	    try {
	      encObj.iv = eccryptoJS.arrayToBuffer(encObj.iv.data);
	      encObj.mac = eccryptoJS.arrayToBuffer(encObj.mac.data);
	      encObj.ciphertext = eccryptoJS.arrayToBuffer(encObj.ciphertext.data);
	      encObj.ephemPublicKey = eccryptoJS.arrayToBuffer(encObj.ephemPublicKey.data);
	      return true;
	    } catch (e) {
	      return false;
	    }
	  }
	  async function loadScript(url) {
	    return new Promise(resolve => {
	      var script = document.createElement('script');
	      script.type = 'text/javascript';
	      script.onload = function () {
	        resolve(true);
	      };
	      script.onerror = () => {
	        console.error('error loading' + url);
	        resolve(false);
	      };
	      script.src = url;
	      document.getElementsByTagName('head')[0].appendChild(script);
	    });
	  }
	  let log = console.log;
	  class nbpeer {
	    static async initLib() {
	      if (!g_initLib) {
	        if (g_isBrowser) {
	          if (!window.io) {
	            await loadScript('https://cdn.socket.io/4.5.0/socket.io.min.js');
	            io = window.io;
	          }
	          if (!window.eccryptoJS) {
	            await loadScript('https://unpkg.com/eccrypto-js@5.4.0/dist/umd/index.min.js');
	            eccryptoJS = window.eccryptoJS;
	          }
	        } else {
	          io = require('socket.io-client').io;
	          eccryptoJS = require('eccrypto-js');
	          require('cross-fetch');
	          commonjsGlobal.localStorage = localStorage$1.exports;
	        }
	        g_initLib = true;
	      }
	    }
	    constructor() {
	      this.eventCB = {};
	      this.enKeys = {};
	      console.log('nbpeer: 1.0.53 - December 27, 2022 11:15:11');
	    }
	    async init() {
	      await nbpeer.initLib();
	      return true;
	    }
	    getId() {
	      return this.id;
	    }
	    async create(info) {
	      await this.init();
	      if (!info.debug) {
	        log = msg => {};
	      }
	      if (!info.id) {
	        info.id = Date.now().toString(36);
	      }
	      this.keypair = eccryptoJS.generateKeyPair();
	      let socketUrl = info.nbNode;
	      if (!socketUrl) {
	        throw 'Need socketUrl or nbNode';
	      }
	      const self = this;
	      return new Promise(resolve => {
	        const manager = new io.Manager(socketUrl, {
	          autoConnect: false
	        });
	        delete info.node;
	        self.id = info.id;
	        const socket = manager.socket('/nbpeer');
	        socket.auth = {
	          info
	        };
	        manager.open(err => {
	          if (err) {
	            return {
	              code: 1,
	              msg: err
	            };
	          }
	        });
	        socket.connect();
	        socket.on('connect', () => {
	          log('connected socket:', socket.id); // x8WIv7-mJelg7on_ALbx

	          self.id = info.id;
	          self.socket = socket;
	          self.restoreEnkeys();
	          self._fire('bridgeConnected', self.id);
	          resolve({
	            code: 0,
	            msg: 'success',
	            id: self.id
	          });
	        });
	        socket.on('disconnect', function () {
	          self._fire('bridgeDisconnected', self.id);
	        });
	        socket.on('exchangeKey', (from_id, args, ret) => {
	          const key = JSON.parse(args)[0];
	          self.setEncryptKey(key, from_id);
	          ret(self.getKey());
	        });
	        socket.onAny(async (event, ...args) => {
	          log('nbpeer:got event:', event, ...args);
	          if (event === 'exchangeKey') return;
	          const from_id = args[0];
	          let argv = [];
	          if (args[1]) {
	            const encrypted = JSON.parse(args[1]);
	            if (!decodeEnc(encrypted)) {
	              const retFn = args[args.length - 1];
	              if (typeof retFn == 'function') {
	                retFn({
	                  code: 1,
	                  msg: 'msg decode error'
	                });
	              }
	              console.error('msg decode error');
	              return;
	            }
	            const deMsg = await eccryptoJS.decrypt(this.keypair.privateKey, encrypted);
	            const para = deMsg.toString();
	            argv = JSON.parse(para);
	          }
	          self._fire(event, from_id, ...argv, args[2]);
	        });
	      });
	    }
	    async restoreEnkeys() {
	      const res = localStorage.getItem('id_key_map');
	      if (!res) return false;
	      try {
	        const idKeyMap = JSON.parse(res);
	        for (const id in idKeyMap) {
	          const enKey = idKeyMap[id + '_hex'];
	          enKey && this.setEncryptKey(enKey, id, false);
	        }
	        return true;
	      } catch (e) {
	        console.error(e);
	        return false;
	      }
	    }
	    async connectTo(desid) {
	      //if (this.enKeys[desid]) return this.enKeys[desid];
	      const key = await this.send(desid, 'exchangeKey', this.getKey());
	      if (key.code === 1000) return false;
	      this.setEncryptKey(key, desid);
	      return key;
	    }
	    getKey() {
	      return eccryptoJS.getPublicCompressed(this.keypair.privateKey).toString('hex');
	    }
	    setEncryptKey(enKey, desid, save = true) {
	      this.enKeys[desid] = eccryptoJS.decompress(fromHexString(enKey));
	      this.enKeys[desid + '_hex'] = enKey;
	      if (save) localStorage.setItem('id_key_map', JSON.stringify(this.enKeys));
	    }
	    async _fire(name, ...args) {
	      const cb = this.eventCB[name];
	      const cb1 = this.eventCB['_any'];
	      const ret = cb ? await cb(...args) : cb1 ? await cb1(name, ...args) : null;
	      const retFn = args[args.length - 1];
	      if (typeof retFn == 'function') {
	        retFn(ret);
	      }
	      return ret;
	    }
	    on(name, cb) {
	      if (!this.eventCB) this.eventCB = {};
	      this.eventCB[name] = cb;
	    }
	    onElse(cb) {
	      this.eventCB['_any'] = cb;
	    }
	    offAll() {
	      this.eventCB = {};
	    }
	    isConnected() {
	      return this.socket && this.socket.connected;
	    }
	    async disconnect() {
	      this.socket && this.socket.disconnect();
	      this.socket = null;
	      localStorage.setItem('id_key_map', null);
	      this.enKeys = {};
	      this._fire('disconnected');
	    }
	    async send(des_id, event, ...args) {
	      return new Promise(resolve => {
	        log('send event:', event, des_id, ...args);
	        let strArgs = null;
	        if (args.length > 0) {
	          strArgs = JSON.stringify(args);
	          if (this.enKeys[des_id] && event != 'exchangeKey') {
	            strArgs = JSON.stringify(eccryptoJS.encryptSync(this.enKeys[des_id], eccryptoJS.utf8ToBuffer(strArgs)));
	          }
	        }
	        this.socket.emit(event, des_id, this.id, strArgs, res => {
	          resolve(res);
	        });
	      });
	    }
	  }
	  return nbpeer;
	});
	}(nbpeer_min));

	var nbpeer = nbpeer_min.exports;

	var isBrowser = isBrowser || new Function('try {return this===window;}catch(e){ return false;}');
	const g_isBrowser = isBrowser();
	let g_initLib = false;
	var fetch = typeof window === 'undefined' ? null : window.fetch;
	class WalletHost {
	  static async initLib() {
	    if (!g_initLib) {
	      if (!g_isBrowser) {
	        fetch = require('cross-fetch');
	      }
	      g_initLib = true;
	    }
	  }
	  constructor() {
	    this.eventCB = {};
	    this.connections = {};
	    console.log('wallet@dwebpay: 1.0.27 - December 27, 2022 11:18:00');
	  }
	  async init({
	    appid,
	    debug
	  }) {
	    await WalletHost.initLib();
	    this.appid = appid;
	    this.approved = false;
	    this.debug = debug;
	    this.id = localStorage.getItem("walletHostId");
	    if (!this.id) {
	      this.id = Date.now().toString(36);
	      localStorage.setItem("walletHostId", this.id);
	    }
	    await nbpeer.initLib();
	  }
	  connectionFromId(appid) {
	    for (const node in this.connections) {
	      const peer = this.connections[node];
	      if (peer.apps[appid]) return peer;
	    }
	    return null;
	  }
	  async getConnection(nbNode) {
	    let peer = this.connections[nbNode];
	    if (peer && peer.isConnected()) {
	      return peer;
	    }
	    peer = new nbpeer();
	    if (await peer.init()) {
	      const r = await peer.create({
	        id: this.id,
	        nbNode,
	        debug: this.debug
	      });
	      if (r.code != 0) {
	        console.error("cannot connect to node:", nbNode);
	        return null;
	      }
	      this.connections[nbNode] = peer;
	      peer.on("connectWallet", async para => {
	        return await this.connectApp(para);
	      });
	      peer.on("ping", (from_id, ping) => {
	        return ping === 'ping' ? "pong" : "wrong";
	      });
	      peer.onElse(async (eName, ...argv) => {
	        console.log("got nbpeer event:", eName, ...argv);
	        return await this._fire(eName, ...argv);
	      });
	      return peer;
	    }
	    console.error("peer.init failed");
	    return null;
	  }
	  async connectApp(appInfo, peer) {
	    const ret = await this._fire('session_request', appInfo.id, {
	      name: 'pair_request',
	      para: [appInfo]
	    });
	    if (ret.code != 0) {
	      this.notify(appInfo.id, 'rejected');
	      return ret;
	    }
	    this.notify(appInfo.id, 'approved', {
	      permissons: appInfo.permissions,
	      wallet_id: this.id,
	      key: peer.getKey()
	    });
	    this.permissions = appInfo.permissions;
	    this.approved = true;
	    return {
	      code: 0,
	      msg: "approved"
	    };
	  }
	  async pair(uri) {
	    const parseUrl = new URL(uri);
	    const url_id = parseUrl.pathname;
	    const nbNode = parseUrl.searchParams.get('node');
	    const path = parseUrl.searchParams.get('path');
	    if (nbNode) {
	      const peer = await this.getConnection(nbNode);
	      if (!peer) {
	        return {
	          code: 1,
	          msg: "cannot connect to node:",
	          nbNode
	        };
	      }
	      const res = await fetch(nbNode + path);
	      if (!res.ok) {
	        return {
	          code: 1,
	          msg: "cannot fetch:" + nbNode + path
	        };
	      }
	      const appInfo = await res.json();
	      console.log(appInfo);
	      if (url_id != appInfo.id) {
	        return {
	          code: 1,
	          msg: "invalid id"
	        };
	      }
	      if (await peer.connectTo(url_id)) {
	        if (!peer.apps) peer.apps = {};
	        peer.apps[appInfo.id] = appInfo;
	      } else {
	        console.error("cannot connect to:", url_id);
	        return;
	      }
	      return await this.connectApp(appInfo, peer);
	    }
	    return {
	      code: 1,
	      msg: "invalid format"
	    };
	  }
	  async getResult(...args) {
	    const fromId = args[0];
	    const func = args[1];
	    const para = args.slice(2);
	    const request = {
	      name: func,
	      para
	    };
	    const res = await this.nbpeer.send(fromId, "session_request", request);
	    return res;
	  }
	  notify(fromId, name, para) {
	    const peer = this.connectionFromId(fromId);
	    if (!peer) {
	      console.error("peer for", fromId, " is not found");
	      return;
	    }
	    peer.send(fromId, 'session_notify', {
	      name,
	      para
	    });
	  }
	  on(eventName, cb) {
	    this.eventCB[eventName] = cb;
	  }
	  onElse(cb) {
	    this.eventCB['_any'] = cb;
	  }
	  async _fire(name, ...argv) {
	    const cb = this.eventCB[name];
	    const cb1 = this.eventCB['_any'];
	    const ret = cb ? await cb(...argv) : cb1 ? await cb1(name, ...argv) : null;
	    argv[argv.length - 1];
	    /*if (typeof retFn == 'function') {
	        retFn(ret)
	    }*/
	    return ret;
	  }
	  async disconnect() {
	    this.nbpeer.disconnect();
	  }
	}

	exports.WalletHost = WalletHost;

	Object.defineProperty(exports, '__esModule', { value: true });

}));
