/* Version: 1.1.22 - February 18, 2023 09:50:54 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.nblib = factory());
})(this, (function () { 'use strict';

  var isBrowser = isBrowser || new Function("try {return this===window;}catch(e){ return false;}");
  var axios;
  const g_isBrowser = isBrowser();
  var _default = {
    API: null,
    APIagent: null,
    dpay: null,
    enable_write: false,
    debug: true
  };
  let g_config = {};
  let log = console.log;
  var blake3;
  var bsvLib;
  var CoinFly = null;
  //const namecheckAPI = "https://util.nbsite.link/namecheck/v1/check/";
  let nodeInfo = {};
  let tld_config = {
    "test": {
      "testing": true,
      "chain": "bsv",
      "address": {
        "payment": "19fLpT5LpaMGKuLfUVqmNdXkVceq2rbjyn",
        "protocol": "1PuMeZswjsAM7DFHMSdmAGfQ8sGvEctiF5",
        "admin": "1KEjuiwj5LrUPCswJZDxfkZC8iKF4tLf9H",
        "other_admins": [{
          "address": "1PuMeZswjsAM7DFHMSdmAGfQ8sGvEctiF5",
          "start_block": 0,
          "end_block": 658652
        }]
      }
    },
    "b": {
      "testing": false,
      "chain": "bsv",
      "address": {
        "payment": "15Cww7izEdyr8QskJmqwC5ETqWREZCjwz4",
        "protocol": "14PML1XzZqs5JvJCGy2AJ2ZAQzTEbnC6sZ",
        "admin": "14PML1XzZqs5JvJCGy2AJ2ZAQzTEbnC6sZ",
        "other_admins": []
      }
    }
  };
  async function loadScript(url) {
    return new Promise(resolve => {
      var script = document.createElement("script");
      script.type = "text/javascript";
      script.onload = function () {
        resolve(true);
      };
      script.onerror = () => {
        console.error("error loading" + url);
        resolve(false);
      };
      script.src = url;
      document.getElementsByTagName("head")[0].appendChild(script);
    });
  }
  /*function polishKeys(obj){
      function _handleKey(item){
          const p20 = parseJson(item.props.p20)
          if(p20&&p20.id=='_mapping'){
              delete p20.id
              for(const k in p20){
                  changeKeyname(item.props,k,p20[k])
              }
              delete item.props.p20
        }
        return item
      }
      if(obj?.keys){
          for(let i=0;i<obj.keys.length;i++){
              obj.keys[i]=_handleKey(obj.keys[i])
          }
      }
      if(obj?.key){
          obj = _handleKey(obj)
      }
      return obj
  } */

  class nblib {
    static async init(option) {
      if (this.inited) return;
      g_config = {
        ..._default,
        ...option
      };
      if (g_config.debug == false) log = msg => {};
      if (g_config.API === null && typeof navigator != 'undefined') {
        g_config.API = navigator.language.toLowerCase().slice(0, 2) === "zh" ? "https://nbnode.maxthon.com/api/" : "https://api.nbdomain.com/api/";
      }
      if (g_config.nbNode) {
        g_config.API = g_config.nbNode + "/api/";
      }
      console.log('nblib: 1.1.22 - February 18, 2023 09:50:54');
      log("init:", g_config);
      nblib.setOpay(g_config.opay);
      nblib.setDpay(g_config.dpay);
      try {
        await nblib._loadLibs();
        nodeInfo = await nblib.getNodeInfo();
        if (nodeInfo) tld_config = nodeInfo.tld;
        if (option.enable_write) {
          await nblib._loadWriteLibs(option.chain); //option.chain=['bsv','ar']
        }
      } catch (e) {
        log(e);
        throw "nblib Init failed:" + e;
      }
      this.inited = true;
    }
    /**
     * Set opay object to be used in webpage.
     * @param {object} - opay or opay2 object
     */
    static setOpay(opay) {
      g_config.opay = opay;
      opay && opay.setRelay(g_config.API);
    }
    static setDpay(dpay) {
      g_config.dpay = dpay;
    }
    static setAPI(option) {
      if (option.API) g_config.API = option.API;
    }
    static async getCoinlib({
      domain,
      tld,
      chain
    }) {
      if (domain) {
        tld = domain.slice(domain.lastIndexOf('.') + 1);
      }
      if (tld) {
        chain = nodeInfo.tld[tld].chain;
      }
      const lib = await CoinFly.create(chain);
      if (!lib) {
        throw 'unsupported chain';
      }
      return lib;
    }
    /**
     * @param  {string} string to hash
     * @return {string} hashed string
     */
    static sha256(dataObj) {
      const bsv = bsvLib.bsv;
      let hash1 = bsv.crypto.Hash.sha256(bsv.deps.Buffer(dataObj)).toString('hex');
      return hash1;
    }
    static validate(domain) {
      domain = domain.toLowerCase();
      const [nid, ext] = domain.split(".");
      if (!ext) return false;
      const keys = Object.keys(tld_config);
      for (var i = keys.length - 1; i >= 0; i--) {
        if (keys[i] === ext) return true;
      }
      return false;
    }
    /**
     * @param  {string} root domain name
     * @return {object} domain object
     */
    static async getDomain(domain) {
      const res = await nblib.readDomain(domain);
      log("getting domain:" + domain + "\n", res);
      if (res && res.code == 0) {
        const inst = new nblib(domain, res);
        return inst;
      }
      log("failed getting domain. res=", res);
      return null;
    }
    static async getUser(account) {
      const dd = account.split('@');
      if (dd.length < 2) throw "account must includs @";
      const domain = dd[1];
      let res = await nblib.readDomain(domain);
      log("getting domain:" + domain + "\n", res);
      if (!res || res.code != 0) {
        console.error(domain + " doesn't exist or error");
        return null;
      }
      res = await nblib.readDomain(account);
      if (res.code != 0) {
        console.error("account doesn't exist");
        return null;
      }
      const inst = new nblib(domain, res);
      inst.info.owner_key = res.obj.publicKey;
      inst.isUser = true;
      return inst;
    }
    constructor(domain, res) {
      this.info = res.obj;
      [this.nid, this.tld] = domain.split('.');
      this.domain = domain;
      this.config = tld_config[this.tld].address;
      this.lastTXID = res.obj.last_txid;
      if (g_config.enable_write) ;
      //log(this);
    }
    /**
     * @param {string} privateKey to be used with nodeJS app
     */
    async setPrivateKey(privateKey) {
      if (!g_config.enable_write) {
        throw "to be able to send transactions, Please enable_write when call init(...)";
      }
      const lib = await nblib.getCoinlib({
        domain: this.domain
      });
      this.pKey = privateKey;
      const pubKey = await lib.getPublicKey(privateKey);
      if (pubKey != this.info.owner_key) {
        throw "Not the owner of:" + this.nid + "." + this.tld;
      }
    }
    async updateUser({
      name,
      publicKey,
      chain,
      broadcast = true
    }) {
      if (this.isUser) throw "Not accessible for user account";
      const value = chain ? {
        name,
        publicKey,
        chain
      } : {
        name,
        publicKey
      };
      let cmd = ["user", "v1", JSON.stringify(value)];
      return await this._sendCommand({
        cmd,
        broadcast
      });
    }
    /**
     * Make a domain as public, so everyone can write to it. inreversible. 
     * @param  {string} domain to set as public
     * @return {json} result
     */
    async makePublic(confirm_domain) {
      if (this.isUser) throw "Not accessible for user account";
      if (confirm_domain != this.nid + '.' + this.tld) {
        throw "Wrong domain, please confirm";
      }
      let cmd = ["make_public"];
      return await this._sendCommand({
        cmd
      });
    }
    /**
     * Write contents to a public domain
     * @param  {object} option - option of the update
     * @param  {object} option.kv - key/value pairs. eg: for key {abc:{abc:"234"}} or {abc:{def:100}} or for keys ab and cd {ab:100,cd:200} 
     * @param  {string} option.tags - string. eg: for key {abc:{abc:"234"}} or {abc:{def:100}} or for keys ab and cd {ab:100,cd:200}  
     * @param  {Boolean} option.isUser - indicate it's for key.domain.tld or key@domain.tld
     * @param  {object[]} option.pay - object array. eg: [{address:"dfdaf"},value:1000}]. some chain, like ar, only supports one receiver per tx
     * @return {json} result of the update
     */
    async writePublicDomain({
      domain,
      kv,
      tags,
      pay
    }) {
      const res = await nblib.readDomain(domain);
      if (res.code != 0) {
        console.error("ERR:", domain, res);
        return;
      }
      if (res.obj.status != 16) {
        console.error("Not a Public domain:", domain);
        return;
      }
      kv.toDomain = domain;
      return await this.updateKey2({
        kv,
        tags,
        pay,
        isUser: false
      });
    }
    /**
     * @param  {object} option - option of the update
     * @param  {object} option.kv - key/value pairs. eg: for key {abc:{abc:"234"}} or {abc:{def:100}} or for keys ab and cd {ab:100,cd:200} 
     * @param  {string} option.tags - string. eg: for key {abc:{abc:"234"}} or {abc:{def:100}} or for keys ab and cd {ab:100,cd:200}  
     * @param  {Boolean} option.isUser - indicate it's for key.domain.tld or key@domain.tld
     * @param  {object[]} option.pay - object array. eg: [{address:"dfdaf"},value:1000}]. some chain, like ar, only supports one receiver per tx
     * @return {json} result of the update
     */
    async updateKey2({
      kv,
      tags = null,
      pay,
      broadcast = true
    }) {
      if (!Array.isArray(kv)) kv = [kv];
      if (!kv[0].k || !kv[0].v) {
        throw new Error("k or v is missing");
      }
      let cmd = ["key", JSON.stringify(kv)];
      if (nodeInfo.payment && nodeInfo.prices && nodeInfo.prices.keyUpdate) {
        let size = JSON.stringify(cmd).length;
        if (size < 1000) size = 1000;
        const lib = await nblib.getCoinlib({
          domain: this.domain
        });
        if (!lib) {
          return {
            code: 1,
            message: "unsupported chain"
          };
        }
        const cut = nodeInfo.prices.keyUpdate.contributeRate;
        const address = nodeInfo.payment[lib.name]; //tld_config[this.tld].address.payment
        const address1 = nodeInfo.fundAddress[lib.name];
        let amount = nodeInfo.prices.keyUpdate[lib.name] * size;
        let amount1 = 0;
        if (cut) {
          amount1 = Math.floor(amount * cut);
          amount = amount - amount1;
        }
        if (!pay) pay = [];
        pay.push({
          address: address,
          value: amount
        });
        if (amount1) pay.push({
          address: address1,
          value: amount1
        });

        //console.log("size;",size,"pay:",pay)
      }

      return await this._sendCommand({
        cmd,
        more_to: pay,
        broadcast
      });
    }
    async updateKey(option) {
      return await this.updateKey2(option);
    }
    async updateTable(ops) {
      if (!ops.k || !ops.tab) {
        throw new Error("k or tab is missing");
      }
      const fullkey = ops.k + '.' + ops.tab;
      const ops1 = {
        k: fullkey,
        v: ops.v,
        props: ops.props
      };
      console.log(ops);
      return await this.updateKey({
        kv: ops1,
        tags: ops.tags,
        pay: ops.pay,
        broadcast: ops.broadcast
      });
    }
    async delKey({
      key,
      broadcast = true
    }) {
      if (typeof key === 'string') key = [key];
      let cmd = ["del_key", JSON.stringify(key)];
      return await this._sendCommand({
        cmd,
        broadcast
      });
    }
    async delChild({
      parent,
      broadcast = true
    }) {
      if (typeof parent === 'string') parent = [parent];
      let cmd = ["del_child", JSON.stringify(parent)];
      return await this._sendCommand({
        cmd,
        broadcast
      });
    }
    async transfer({
      owner
    }) {
      if (this.isUser) throw "Not accessible for user account";
      if (!owner) {
        return {
          code: -1,
          message: "owner information not set"
        };
      }
      try {
        const lib = await nblib.getCoinlib({
          domain: this.domain
        });
        let cmd = ["transfer", owner];
        return await this._sendCommand({
          cmd
        });
        const owner_pubKey = owner;
        //    const addr = await lib.getAddress(owner_pubKey); //bsLib.PublicKey.fromHex(owner_pubKey).toAddress().toString();

        //     const more_to = [{
        //         address:this.config.payment,value:1000
        //     }]

        const sendOption = {
          protocol: this.config.protocol,
          nid: this.nid,
          key: g_config.dpay ? this.info.owner_key : this.pKey,
          //g_config.opay ? this.info.owner_key:this.pKey,
          cmd: cmd,
          lastTXID: this.lastTXID,
          more_to: more_to,
          broadcast: true,
          coinlib: lib
        };
        const ret = await nblib._baseSendCommand(sendOption);
        return ret;
      } catch (e) {
        console.error(e);
        return {
          code: -1,
          message: e.message
        };
      }
      return {
        code: -2,
        message: "shall not be here"
      };
    }
    static async mangoQuery(exp) {
      const hasCount = !!exp.count;
      if (hasCount) {
        exp = exp.count;
      }
      if (hasCount) exp = {
        count: exp
      };
      const ret = await this._invokeAPI({
        para: "/mq/",
        body: exp,
        method: "post"
      });
      /*for(let i=0;i<ret.length;i++){
          ret[i] = polishKeys(ret[i])
      }*/
      return ret;
    }
    static async dbQuery(exp, ...para) {
      const ret = await this._invokeAPI({
        para: "/dbq/",
        body: {
          exp,
          para
        },
        method: "post"
      });
      return ret;
    }
    static async getChildCount(parent) {
      const ret = await this._invokeAPI({
        para: "/qc/" + parent
      });
      return ret;
    }
    async sell({
      buyer,
      price,
      expire,
      clear_data,
      note
    }) {
      if (this.isUser) throw "Not accessible for user account";
      if (!buyer || !price || !expire) {
        throw "must have buyer, price and expire";
      }
      let op = {
        buyer: buyer,
        price: price,
        expire: expire,
        clear_data: clear_data,
        note: note
      };
      if (op.buyer !== "any") {
        //domain
        const info = await nblib.readDomain(op.buyer);
        log("buyer info:", info);
        if (info.code == 0) {
          op.buyer = info.obj.owner;
        } else {
          return {
            code: 1,
            message: "no valid buyer, must be NBdomain"
          };
        }
      }
      let cmd = ["sell", JSON.stringify(op)];
      console.log(cmd);
      return await this._sendCommand({
        cmd
      });
    }
    static _configFromProtocol(protocol) {
      const keys = Object.keys(tld_config);
      for (var i = keys.length - 1; i >= 0; i--) {
        const config = tld_config[keys[i]];
        if (config.address.protocol === protocol) return config;
      }
      return null;
    }
    async _sendCommand({
      cmd,
      more_to = null,
      broadcast = true
    }) {
      if (!this.pKey && g_config.dpay == null) {
        throw "please setPayment first";
      }
      const lib = await nblib.getCoinlib({
        domain: this.domain
      });
      const sendOption = {
        protocol: this.config.protocol,
        nid: this.nid,
        key: g_config.dpay ? this.info.owner_key : this.pKey,
        //g_config.opay ? this.info.owner_key:this.pKey,
        cmd: cmd,
        more_to: more_to,
        lastTXID: this.lastTXID,
        broadcast: broadcast,
        coinlib: lib
      };
      //console.log(sendOption);
      const ret = await nblib._baseSendCommand(sendOption);
      return ret;
    }
    /**
     * @param  {string} data_hash - hasded string of data
     * @param  {string} strSig - signature
     * @return {bool} result of verify
     */
    async verifySig(data_hash, strSig) {
      if (!g_config.enable_write) {
        throw "to be able to send transactions, Please enable_write when call init(...)";
      }
      const lib = await nblib.getCoinlib({
        domain: this.domain
      });
      return lib.verify(this.info.owner_key, data_hash, strSig);

      //let sig = bsLib.crypto.Signature.fromString(strSig);
      //let pubKey = bsLib.PublicKey.fromString(this.info.owner_key);
      //let hash2 = bsLib.crypto.Hash.sha256(bsLib.deps.Buffer.from(data_hash,'hex'));
      //return bsLib.crypto.ECDSA.verify(hash2,sig,pubKey);
    }

    async readKey(key) {
      return await nblib.readDomain(key + '.' + this.domain);
    }
    async readUser(user) {
      return await nblib.readDomain(key + '@' + this.domain);
    }
    async isOwner(address) {
      return this.info.owner == address;
    }

    /**
     * @param  {object} option - 
     * @param  {domain} option.domain - domain to buy
     * @return {json} result
     */
    async buy(option) {
      if (this.isUser) throw "Not accessible for user account";
      if (!option.domain) throw "option.domain is missing";
      const {
        domain,
        note
      } = option;
      let key = {};
      if (g_config.dpay) {
        //if(g_config.opay){
        key.publicKey = this.info.owner_key;
      } else {
        key.privateKey = this.pKey;
      }
      const lib = await nblib.getCoinlib({
        domain: domain
      });
      const res = await nblib.readDomain(domain);
      log("domain is", domain, " res:", res);
      if (res.code != 0) {
        return {
          code: 1,
          message: "Domain is not registered"
        };
      }
      if (!res.obj.sell_info) {
        return {
          code: 2,
          message: "Domain is not on sale"
        };
      }
      const {
        buyer,
        price,
        expire,
        sell_txid
      } = res.obj.sell_info;
      const privKey = key.privateKey;
      const pubKey = key.publicKey;
      const dom = domain.split('.');
      const config = tld_config[dom[1]].address;
      const rExpire = new Date(expire);
      if (Date.now() > rExpire) {
        return {
          code: 3,
          message: "Sell Expired"
        };
      }
      if (buyer != "any") {
        let address = null;
        if (privKey) {
          const pKey = await lib.getPublicKey(privKey);
          address = await lib.getAddress(pKey);
        }
        if (pubKey) address = await lib.getAddress(pubKey);
        if (address != buyer) {
          log("address:", address, " buyer:", buyer);
          return {
            code: 4,
            message: "Incorrect Buyer"
          };
        }
      }
      const pay1 = price;
      let pay2 = price * (nodeInfo.prices.sellFee ? nodeInfo.prices.sellFee : 0.1);
      if (pay2 < 600) pay2 = 600;
      const refer = option.refer ? option.refer : "none";
      const cmd = ['buy', 'v2', JSON.stringify({
        domain: domain,
        sell_txid: sell_txid,
        note: note
      }), refer];
      const more_to = [{
        address: res.obj.owner,
        value: pay1
      }, {
        address: config.payment,
        value: pay2
      }];
      const sendOption = {
        protocol: this.config.protocol,
        nid: this.nid,
        key: g_config.dpay ? this.info.owner_key : this.pKey,
        //g_config.opay ? this.info.owner_key:this.pKey,
        cmd: cmd,
        more_to: more_to,
        coinlib: lib
      };
      const ret = await nblib._baseSendCommand(sendOption);
      return ret;
    }
    static async _loadLibs() {
      if (!g_isBrowser) {
        axios = require('axios');
      } else {
        if (!window.axios) await loadScript("https://unpkg.com/axios/dist/axios.min.js");
        axios = window.axios;
      }
    }
    static async _loadWriteLibs(chains) {
      if (!chains) chains = ['bsv', 'ar'];
      if (g_isBrowser) {
        await loadScript("https://unpkg.com/hash-wasm@4.9.0/dist/blake3.umd.min.js");
        blake3 = hashwasm.blake3;
        if (!window.coinfly) await loadScript("https://unpkg.com/coinfly@latest/dist/coinfly.min.js");
        CoinFly = window.coinfly;
      } else {
        CoinFly = require('coinfly');
        blake3 = require('hash-wasm').blake3;
      }
      for (const chain of chains) {
        if (chain == 'bsv') bsvLib = await CoinFly.create('bsv', {
          nbAPI: g_config.API,
          ...g_config.bsvOption
        });
        if (chain == 'ar') await CoinFly.create('ar', {
          nbAPI: g_config.API,
          ...g_config.arOption
        });
      }
    }
    static async getRate(symbol) {
      return await this._invokeAPI({
        para: "tools/market/rates/" + symbol
      });
    }
    static async updateAPI() {
      if (g_config.APIagent) {
        const res = await axios.get(g_config.APIagent);
        if (res.data) {
          if (res.data.API && g_config.API != res.data.API) {
            g_config.API = res.data.API;
            nodeInfo = await nblib.getNodeInfo();
          }
        }
      }
    }
    static async sendTXByNode(data) {
      log("------------------------sendTXByNode---------------------: ");
      log("data:", data);
      await nblib.updateAPI();
      if (CoinFly.nbpay) CoinFly.nbpay.clearUTXOCache();
      const url = g_config.API + "sendtx";
      console.log("url:", url);
      try {
        let res = await axios.post(url, {
          rawtx: data.rawtx,
          more_rawtx: data.more_rawtx,
          chain: data.chain,
          oData: data.more_data
        });
        let json = res.data;
        log("sendTXByNode result:", json);
        if (data.cost) json.cost = data.cost;
        return json;
      } catch (e) {
        return {
          code: 1,
          message: e.message
        };
      }
    }
    static _toArOption(option) {
      //console.log(option)
      let data = option.data ? option.data.slice(0, 4) : option.pay.to[0].data.slice(0, 4);
      if (option && option.pay && option.pay.to) {
        const tos = option.pay.to.filter(item => Object.keys(item)[0] === 'address');
        option.pay.to = tos;
      }
      let tags = {
        nbprotocol: 'nbd',
        nbdata: JSON.stringify(data)
      };
      option.tags = tags;
      option.data = "nb";
      return option;
    }
    static async _opay_baseSendCommand({
      protocol,
      nid,
      key,
      cmd,
      last_txid,
      more_to = null,
      broadcast = true,
      coinlib
    }) {
      if (!g_config.enable_write) {
        throw "to be able to send transactions, Please enable_write when call init(...)";
      }
      const lib = coinlib;
      const pubKey = key;
      const address = pubKey ? await lib.getAddress(pubKey) : null;
      const timestamp = Math.floor(Date.now() / 1000);
      cmd = [protocol, nid].concat(cmd);
      const cmds = JSON.stringify(cmd);
      let hash = await blake3(cmds, 128);
      return new Promise(resolve => {
        //const address = pubKey ? bsLib.PublicKey.fromHex(pubKey).toAddress().toString() : null;

        let nbd_json = {
          v: 3,
          ts: '{{timestamp}}',
          hash: hash
        };
        const nbd_attribute = JSON.stringify(nbd_json);
        let reqBody = {
          app: {
            name: "NBdomain"
          },
          more_data: cmds,
          data: ['nbd', nbd_attribute],
          to: [{
            protocol: "bitIdentity"
          }],
          broadcast: false,
          chain: lib.name
        };
        if (pubKey) {
          reqBody.payer = address;
          reqBody.to[0].value = {
            public_key: pubKey
          };
        }
        //reqBody.data = reqBody.data.concat(cmd);

        if (more_to) {
          reqBody.to = reqBody.to.concat(more_to);
        }
        if (lib.name == 'ar') {
          reqBody = nblib._toArOption(reqBody, cmd);
        }
        g_config.opay.pay(reqBody, async ret => {
          ret.chain = lib.name;
          if (broadcast) {
            if (ret.code == 0) {
              ret = await nblib.sendTXByNode(ret);
              if (ret) ret.ts = timestamp;
            }
          }
          resolve(ret);
          if (ret.usedWallet) {
            opay.setWallet(ret.usedWallet);
          }
          if (broadcast == false) return false;
          return {
            code: 0,
            id: ret.id,
            message: "ok"
          };
        });
      });
    }
    static async _dpay_baseSendCommand({
      protocol,
      nid,
      key,
      cmd,
      last_txid,
      more_to = null,
      broadcast = true,
      coinlib
    }) {
      if (!g_config.enable_write) {
        throw "to be able to send transactions, Please enable_write when call init(...)";
      }
      const lib = coinlib;
      const pubKey = key;
      const address = pubKey ? await lib.getAddress(pubKey) : null;
      const timestamp = Math.floor(Date.now() / 1000);
      cmd = [protocol, nid].concat(cmd);
      const cmds = JSON.stringify(cmd);
      let hash = await blake3(cmds, 128);
      let nbd_json = {
        v: 3,
        ts: '{{timestamp}}',
        hash: hash
      };
      const nbd_attribute = JSON.stringify(nbd_json);
      let reqBody = {
        app: {
          name: "NBdomain"
        },
        more_data: cmds,
        data: ['nbd', nbd_attribute],
        to: [{
          protocol: "bitIdentity"
        }],
        broadcast: false,
        chain: lib.name
      };
      if (pubKey) {
        reqBody.payer = address;
        reqBody.to[0].value = {
          public_key: pubKey
        };
      }
      //reqBody.data = reqBody.data.concat(cmd);

      if (more_to) {
        reqBody.to = reqBody.to.concat(more_to);
      }
      if (lib.name == 'ar') {
        reqBody = nblib._toArOption(reqBody, cmd);
      }
      let ret = await g_config.dpay.signTransaction({
        options: reqBody
      });
      ret.chain = lib.name;
      if (broadcast == false) return ret;
      if (ret.code == 0) {
        ret = await nblib.sendTXByNode(ret);
        if (ret) ret.ts = timestamp;
      } else {
        console.error(ret);
      }
      return ret;
    }
    static async _baseSendCommand(sendOption) {
      //console.log('_baseSendCommand:',sendOption)
      if (!g_config.enable_write) {
        throw "to be able to send transactions, Please enable_write when call init(...)";
      }
      let {
        protocol,
        nid,
        key,
        cmd,
        last_txid,
        more_to,
        broadcast,
        coinlib
      } = sendOption;
      if (g_config.opay && !sendOption.forcePrivKey) return nblib._opay_baseSendCommand(sendOption);
      if (g_config.dpay && !sendOption.forcePrivKey) return nblib._dpay_baseSendCommand(sendOption);
      const lib = coinlib ? coinlib : bsvLib;
      const privKey = key;
      const timestamp = Math.floor(Date.now() / 1000);
      cmd = [protocol, nid].concat(cmd);
      const cmds = JSON.stringify(cmd);
      let hash = await blake3(cmds, 128);
      let nbd_json = {
        v: 3,
        ts: '{{timestamp}}',
        hash: hash
      };
      const nbd_attribute = JSON.stringify(nbd_json);
      let config = {
        data: ['nbd', nbd_attribute],
        more_data: cmds,
        pay: {
          key: privKey,
          feeb: 0.5,
          to: [{
            protocol: "bitIdentity",
            value: {
              privateKey: privKey
            }
          }]
        }
      };
      //config.data = config.data.concat(cmd);

      if (more_to) {
        config.pay.to = config.pay.to.concat(more_to);
      }
      let data = {};
      let res = null;
      if (lib.name == 'bsv') {
        log("before gentx:", JSON.stringify(config));
        res = await lib.build(config);
        data = res;
      } else if (lib.name == 'ar') {
        config = nblib._toArOption(config, cmd);
        res = await lib.build(config);
        if (res.code == 0) data = res;
      } else {
        data = await lib.build(config);
      }
      if (data.rawtx) {
        data.chain = lib.name;
        if (!broadcast) return {
          code: 0,
          ...data
        };
        let ret = await nblib.sendTXByNode(data);
        if (ret) ret.ts = timestamp;
        return ret;
      } else {
        return res;
      }
    }
    static isValidAdmin(tld, address) {
      const all = tld_config[tld].address;
      if (address == all.admin) return true;
      return all.other_admins.includs(address);
    }
    static async registerDomain(domain, option) {
      if (!g_config.enable_write) {
        throw "to be able to send transactions, Please enable_write when call init(...)";
      }
      const lib = await nblib.getCoinlib({
        domain
      });
      const dom = domain.split('.');
      const config = tld_config[dom[1]].address;
      const namecheckAPI = tld_config[dom[1]].price_url;
      try {
        const res = await nblib.getPrice(domain);
        if (res.code == 0) {
          return {
            code: 1,
            message: "Domain is registered"
          };
        }
        if (res.price == undefined) {
          return {
            code: 2,
            message: "Domain is reserved"
          };
        }
        if (namecheckAPI) await axios.get(namecheckAPI + encodeURIComponent(domain) + "?prereg=check");
        const cmd = ['register', 'v2'];
        const more_to = [{
          address: config.payment,
          value: res.price
        }];
        let attrib = {};
        if (option && option.toKey) attrib.toKey = option.toKey;
        if (option && option.refer) attrib.refer = option.refer;
        if (attrib != {}) cmd.push(JSON.stringify(attrib));
        const sendOption = {
          protocol: config.protocol,
          nid: dom[0],
          key: g_config.dpay ? option?.publicKey : option?.privateKey,
          //g_config.opay ? option?.publicKey : option?.privateKey,
          cmd: cmd,
          more_to: more_to,
          broadcast: !(option.broadcast == false),
          coinlib: lib
        };
        const ret = await nblib._baseSendCommand(sendOption);
        return ret;
      } catch (e) {
        log(e);
        return {
          code: 100,
          message: e
        };
      }
    }
    static async _invokeAPI({
      para,
      body,
      method = 'get'
    }) {
      await nblib.updateAPI();
      //const url = g_config.API+para;
      const config = {
        method,
        url: para,
        baseURL: g_config.API,
        headers: {
          'content-type': 'application/json;charset=UTF-8',
          'Authorization': 'Bearer ' + g_config.token
        },
        mode: 'cors',
        cache: 'default'
      };
      method === 'get' ? config.url = para : config.data = body;
      try {
        //const url1 = encodeURI(url);
        const res = await axios.request(config);
        if (res) {
          return res.data;
        }
      } catch (e) {
        log(e);
      }
      return null;
    }
    /**
     * @return {json} nodeInfo from node
     */
    static async getNodeInfo() {
      let ret = await nblib._invokeAPI({
        para: "nodeInfo"
      });
      return ret;
    }
    static async getTLDinfo() {
      return await nblib._invokeAPI({
        para: "tld"
      });
    }
    /**
     * @param  {string} domain - one or more domains, separated by ',' .eg "test.b" "test.b,www.abc.b" "aaa.test886.test/all,aaa.test886.test/1"
     * @param  {Boolean}
     * @return {json}
     */
    static async queryDomain(domain, full = false, price = true) {
      const para = full ? "/qf/" + domain + "?price=" + (price ? "true" : "false") : "/q/" + domain + "?price=" + (price ? "true" : "false");
      const res = await nblib._invokeAPI({
        para
      });
      return res;
    }
    static async getOnSale() {
      const para = "onSale";
      const res = await nblib._invokeAPI({
        para
      });
      return res;
    }
    static async readDomain(domain, full = false, price = false) {
      const para = "?nid=" + domain + "&full=" + (full ? "true" : "false") + "&price=" + (price ? "true" : "false");
      const res = await nblib._invokeAPI({
        para
      });

      //polishKeys(res.obj)

      return res;
    }
    static async getPrice(domain) {
      let res = await nblib.queryDomain(domain, false, true);
      if (res && res.length == 1) res = res[0];
      return res;
    }
    static async readUser(account) {
      const para = "/user/" + account;
      const res = await nblib._invokeAPI({
        para
      });
      return res;
    }
    /**
     * @param  {string} address - address of the domains
     * @return {json} result
     */
    static async domainFromAddress(address) {
      return await nblib._invokeAPI({
        para: "findDomain?address=" + address
      });
    }
    /**
     * findDomain according to the option
     * 
     * @param  {string} option.address [owner address]
     * @param  {object} option.time{from:,to:} [register time]
     * @return {[type]}        [description]
     */
    static async findDomain(option) {
      return await nblib._invokeAPI({
        para: "findDomain?option=" + JSON.stringify(option)
      });
    }
  }
  if (g_isBrowser == false) module.exports = nblib;

  return nblib;

}));
