
const arrNotify = []
let showing = false
let gll = null
function incomingCall(para) {
    arrNotify.push(para)
    if (!showing)
        gll.notify.checkAndShowNotify()
}
export class Notify {
    static create(gl) {
        const inst = new Notify
        inst.gl = gl
        gll = gl
        inst.audio = new Audio()
        window.incomingCall = incomingCall
        gl.api.registerMessageChannel({ cb: incomingCall, name: "notify_window" })
        inst.incomingCall = incomingCall
        return inst
    }
    async checkAndShowNotify() {
        showing = true
        const { api, notify } = this.gl
        const config = await api.getBrowserPref({ keys: ["settings.mxnotify.enable", "settings.mxnotify.min_amount", "settings.mxnotify.voice_enable"] })
        if (arrNotify.length > 0) {
            api.handleBrowserWindow({ type: "notify", cmd: 'show' })
            let arrAsset = []
            while (arrNotify.length > 0) {
                const item = arrNotify.shift()
                const { type, data } = item
                if (type === 'asset_change') {
                    const { amount, asset } = api.parsePrice(data)
                    arrAsset.push({ amount, asset })
                }
            }
            let sound = null
            let asset = 'gold', amount = 10
            if (config['settings.mxnotify.voice_enable'] !== false) sound = `/assets/${asset}_${amount > 0 ? 'inc' : 'dec'}.mp3`
            if (Math.abs((config['settings.mxnotify.min_amount'] || 0)) <= amount)
                await notify.showAssetAnimation({ arrAsset, sound, url: "https://my.maxthon.com/profile/asset/detail" })

            api.handleBrowserWindow({ type: "notify", cmd: "hide" })
        }
        showing = false
    }
    run() {
    }
    async showAssetAnimation({ arrAsset, url, sound }) {
        return new Promise(resolve => {
            const { api } = this.gl
            const self = this
            const winElm = document.querySelector(".window")
            winElm.addEventListener('click', () => {
                window.open(url)
            })
            const _setupElm = (parent, amount, asset) => {
                const picElm = parent.querySelector(".asset-pic")
                const amountElement = parent.querySelector('#assetAmount');
                amountElement.className = `anime-number anime-number-${asset}`
                amountElement.innerText = amount
                picElm.src = "/assets/" + asset + ".svg"
            }
            const { amount, asset } = arrAsset[0]
            const assetElm = document.querySelector(".asset")
            _setupElm(assetElm, amount, asset)

            const appendedNode = []
            arrAsset.shift()
            while (arrAsset.length > 0) {
                const item = arrAsset.shift()
                const { amount, asset } = item
                const assetElm1 = assetElm.cloneNode(true)
                _setupElm(assetElm1, amount, asset)
                winElm.appendChild(assetElm1)
                appendedNode.push(assetElm1)
            }

            let timeline = anime.timeline({
                easing: 'easeOutElastic',
                autoplay: false
            })
                .add({
                    targets: '.window',
                    translateY: -100,
                    opacity: [0, 0.85],
                    duration: 500,
                    complete: () => {
                        if (sound) {
                            this.audio.src = sound;
                            this.audio.play()
                        }
                    }
                })
                .add({
                    targets: ['.asset'],
                    translateY: [100, 0],
                    opacity: [0, 1],
                    delay: anime.stagger(50, { start: 300 }), // stagger the pop-up effect
                    rotateY: 360,
                    duration: 500,
                })
                /*.add({
                    targets: '.anime-number .el',
                    translateY: [30, 0],
                    opacity: [0, 1],
                    delay: anime.stagger(50, { start: 300 }), // stagger the pop-up effect 
                    easing: 'easeOutElastic',  // add elastic ease-out effect
                    duration: 500,
                }) */
                .add({
                    targets: '.window',
                    translateY: 0,
                    duration: 500,
                    complete: function () {
                        appendedNode.forEach(node => node.remove())
                        resolve(true)
                    }
                }, '+=500')
            timeline.play()
        })
    }
}