/**
    @fileOverview
    the Main Method for Sina WeiBo
    @author liujia <liujia@maxthon.net>
 */




var Sina = {
    COMPANY: 'sina',

    // url集合
    ACTION_MAP: {
        accessTokenUrl: 'https://api.weibo.com/oauth2/authorize?display=mobile&client_id=2676377949&redirect_uri=http://sns.user.maxthon.cn/authorize/sina&response_type=code&state=sina:02F3DC97C47D7644ABF6EC671671D365;pcmxSide',
		logout: 'https://api.weibo.com/2/account/end_session.json',
        usersShowUrl: 'https://api.weibo.com/2/users/show.json',
		emotionsUrl: 'https://api.weibo.com/2/emotions.json',
        statusesUpdateUrl: 'https://api.weibo.com/2/statuses/share.json',
        statusesUploadUrl: 'https://api.weibo.com/2/statuses/share.json',
        atUsersUrl: 'https://api.weibo.com/2/search/suggestions/at_users.json'
    },

    // 申请应用的key和密码
    APP_CONFIG: {
        key: '2676377949',
        secret: '4553c05b774c586fed3ae7b21820aec4'
    },

	// access_token信息
	accessConfig: {
        access_token: '',
        expires_in: '',
        uid: ''
    },

    /**
        @description 获取access_token
		@param {string} username 用户名
		@param {string} password 密码
		@param {string} remember 是否记住
     */
    accessToken: function (wrapSector, callback) {
        // 10.100.0.11
        // 如果你想让用户重新登录，请在调用authorize接口时传入参数：forcelogin=true，默认不填写此参数相当于forcelogin=false。
        var warp = $(wrapSector);
        var ifr = $('<iframe id="token-iframe" src="' + Sina.ACTION_MAP.accessTokenUrl + '&r=' + Math.random().toString().slice(2, 10) + '"></iframe>');
        ifr.load(function() {
            ifr[0].contentWindow.oncontextmenu = function () { return false; };
            var href = ifr[0].contentWindow.location.href;
            if (href.indexOf('http://sns.web.maxthon.cn/index.html') < 0) return;

            warp.hide();
            ifr.remove();
            var result = {};
            href.split('?')[1].split('&').forEach(function(n) {
                var n = n.split('=');
                result[n[0]] = n[1];
            });

            Sina.accessConfig.access_token = result.access_token;
            Sina.accessConfig.expires_in = result.expires_in;
            Sina.accessConfig.uid = result.uid;

            // 改变当前用户类型
            LS_OBJECT.curType = Sina.COMPANY;
            LS_OBJECT.curId = Sina.accessConfig.uid;
            LS_OBJECT[LS_OBJECT.curType] = LS_OBJECT.curId;
            // 存入uids数组
            if (!LS_OBJECT.uids) {
                LS_OBJECT.uids = [];
            }
            var key = LS_OBJECT.curType + WEIBO_SEPARATOR +
                LS_OBJECT.curId;
            if (LS_OBJECT.uids.indexOf(key) == -1) {
                LS_OBJECT.uids.push(key);
                LS_OBJECT[key] = {};
            }

            // 自动登录
            LS_OBJECT[key].sign = 1;
            LS_OBJECT[key].uid = Sina.accessConfig.uid;
            LS_OBJECT[key].access_token = Sina.accessConfig.access_token;
            LS_OBJECT[key].expires_in = Sina.accessConfig.expires_in;
            Global.writeLS();
            // Sina.sso();
            callback(result);
        });
        
        warp.append(ifr);
    },

    /**
        @description 微博退出接口
     */
    logout: function (callback) {
        $.ajax({
            type: 'GET',
            data: {
                access_token: Sina.accessConfig.access_token
            },
            url: Sina.ACTION_MAP.logout,
            async: false,
            success: function (result) {
                callback && callback();
            },
            error: function (result) {
                Sina.errorHandler(result);
            }
        });
    },

	/**
        @description 按用户ID或昵称返回用户资料以及用户的最新发布的一条微博消息
		@param {string} key 用户ID(uid)或用户昵称（screen_name）
		@param {string|int64} value key对应的值
		@param {function} callback 回调函数
     */
    usersShow: function (key, value, callback) {
		if(!Sina.hasAccessToken()) {
			return {errorStr: '认证失败'};
		};

		var ro = {};
		var parameterMap = {
            access_token: Sina.accessConfig.access_token
        };
		parameterMap[key] = value;

        $.ajax({
            type: 'GET',
            data: parameterMap,
			dataType: 'json',
            url: Sina.ACTION_MAP.usersShowUrl,
			async: false,
            success: function (result) {
				ro = result;
				Sina.execCallback(callback, result);
            },
            error: function (result) {
				ro = Sina.errorHandler(result);
				Sina.execCallback(callback, Sina.errorHandler(result));
            }
        });
		return ro;
    },



	/**
        @description 返回新浪微博官方所有表情、魔法表情的相关信息
		@param {string} type 表情类别，face：普通表情、ani：魔法表情、cartoon：动漫表情，默认为face
		@param {string} 语言类别，cnname：简体、twname：繁体，默认为cnname
     */
    emotions: function (type, language) {
		if(!Sina.hasAccessToken()) {
			return {errorStr: '认证失败'};
		};

		var ro = {};
		var parameterMap;

		type = type || 'face';
        language = language || 'cnname';

		parameterMap = {
			access_token: Sina.accessConfig.access_token,
			type: type,
			language: language
		};

        $.ajax({
            type: 'GET',
            data: parameterMap,
			dataType: 'json',
            url: Sina.ACTION_MAP.emotionsUrl,
            async: false,
            success: function (result) {
                ro = result;
            },
            error: function (result) {
                ro = Sina.errorHandler(result);
            }
        });
        return ro;
    },


	/**
        @description 发布一条新微博
		@param {string} status 要发布的微博文本内容，必须做URLencode，内容不超过140个汉字
		@param {function} callback 回调函数
     */
    statusesUpdate: function (status, callback) {
		if(!Sina.hasAccessToken()) {
			return;
		};

        var parameterMap = {
			access_token: Sina.accessConfig.access_token,
			status: status
		};

        $.ajax({
            type: 'POST',
            data: parameterMap,
			dataType: 'json',
            url: Sina.ACTION_MAP.statusesUpdateUrl,
            success: function (result) {
                Sina.execCallback(callback, result);
            },
            error: function (result) {
				Sina.execCallback(callback, Sina.errorHandler(result));
            }
        });
    },

	/**
        @description 上传图片并发布一条新微博
		@param {string} status 要发布的微博文本内容，必须做URLencode，内容不超过140个汉字
		@param {string} pic 要上传的图片，仅支持JPEG、GIF、PNG格式，图片大小小于5M
        @param {boolean} 是否是长微博
		@param {function} callback 回调函数
     */
    statusesUpload: function (status, pic, longWeibo, callback) {
		if(!Sina.hasAccessToken()) {
			return;
		};

        var parameterMap;
        var ro = {};
        var formdata;
        var boundary;
        var buffer;
        var bb;
		var key;

        // 默认值
        if (longWeibo) {
            //status = '长微博(' + Core.callFunc('deal time to YMDHMS') +')';
            status = status.substr(0, 17) + '...';
        } else if (!status) {
            status = '分享图片';
        }
        status = status.replace(/[\r\n\t]+/g, ' ');

status += ' http://maxthon.cn ';

		parameterMap = {
			access_token: Sina.accessConfig.access_token,
			status: status
		};

        if (window.FormData) {
            formdata = false;
            formdata = new FormData();
            for (key in parameterMap) {
                formdata.append(key, parameterMap[key]);
            }
            formdata.append('pic', pic);

            $.ajax({
                type: 'POST',
                data: formdata,
				dataType: 'json',
                url: Sina.ACTION_MAP.statusesUploadUrl,
                processData: false,
                contentType: false,
                async: true,
                success: function (result) {
					Sina.execCallback(callback, result);
                },
                error: function (result) {
                    Sina.execCallback(callback, Sina.errorHandler(result));
                }
            });
        }
        else {
            boundary = '--------FormData' + Math.random();
            buffer = '--' + boundary + '\r\n';
            for (key in parameterMap) {
                buffer += 'Content-Disposition: form-data; name="' + key + '";\r\n\r\n';
                buffer += parameterMap[key] + '\r\n';
                buffer += '--' + boundary + '\r\n'
            }
            buffer += 'Content-Disposition: form-data; name="pic"; ';
            buffer += 'filename="' + pic.fileName + '";\r\n';
            buffer += 'Content-Type: '+(pic.fileType || pic.type);
            buffer += ';\r\n\r\n';
            var uploadData;
            if (Blob) {
                bb = new Blob([buffer + pic + '\r\n--' + boundary + '--']);
                uploadData = bb;
            } else {
                if (BlobBuilder) {
                    bb = new BlobBuilder();
                }
                else {
                    bb = new WebKitBlobBuilder();
                }
                bb.append(buffer);
                bb.append(pic);
                bb.append('\r\n--' + boundary + '--');
                uploadData = bb.getBlob();
            }

            $.ajax({
                type: 'POST',
                data: uploadData,
				dataType: 'json',
                url: Sina.ACTION_MAP.statusesUploadUrl,
                processData: false,
                contentType: 'multipart/form-data; boundary=' + boundary,
                success: function (result) {
                    Sina.execCallback(callback, result);
                },
                error: function (result) {
                    Sina.execCallback(callback, Sina.errorHandler(result));
                }
            });
        }
    },

	/**
        @description @用户时的联想建议
        @param {string} q 搜索的关键字，必须做URLencoding
		@param {int} count 返回的记录条数，默认为5，粉丝最多1000，关注最多2000
		@param {int} type 联想类型，0：关注、1：粉丝，默认为0
		@param {int} range 联想范围，0：只联想关注人、1：只联想关注人的备注、2：全部，默认为2
		@param {function} callback 回调函数
     */
    atUsers: function (q, count, type, range, callback) {
		if(!Sina.hasAccessToken()) {
			return;
		};

        // 默认值
        count = count || 5;
        type = type || 0;
        range = range || 2;

		var parameterMap = {
			access_token: Sina.accessConfig.access_token,
			q: q,
			count: count,
			type: type,
			range: range
		};

        $.ajax({
            type: 'GET',
            data: parameterMap,
			dataType: 'json',
            url: Sina.ACTION_MAP.atUsersUrl,
            success: function (result) {
				Sina.execCallback(callback, result);
            },
            error: function (result) {
				Sina.execCallback(callback, Sina.errorHandler(result));
            }
        });
    },


	/**
        @description 错误信息处理
		@param {mix} result ajax返回结果
     */
    errorHandler: function (result) {
        var ret = {};
        var resError;
        try {
            // 超时判断
            if (!result.responseText) {
                ret.errorStr = '连接超时，请检查网络';
                return ret;
            }
            resError = eval('(' + result.responseText + ')');
			var errorCode = resError.error_code;
			if(errorCode in SINA_WEIBO_ERRORS) {
				ret.errorStr = SINA_WEIBO_ERRORS[errorCode];
			}
			else {
				ret.errorStr = resError.error ? resError.error : '未知错误';
			}
			if(errorCode == '21325' || errorCode == '21327' || errorCode == '21332' || errorCode == '21315' || errorCode == '21316' || errorCode == '21317' || errorCode == '21319') {//access_token过期，需要从新获取
				Sina.getNewAccessToken();
			}
        }
        catch (e) {
            ret.errorStr = result.responseText;
        }
        return ret;
    },

	/**
        @description access_token超时后，清除storage中的旧数据，并让用户重新登录，以获取新的access_token
     */
	getNewAccessToken: function () {
		//重置accessConfig对象
		accessConfig.access_token = '';
		accessConfig.expires_in = '';
		accessConfig.uid = '';
		//清除当前的账号信息
		var type = LS_OBJECT.curType;
        var key = LS_OBJECT.curType + WEIBO_SEPARATOR + LS_OBJECT.curId;
        var uids = LS_OBJECT.uids;
        var tmp;
        // 清除对应信息
        uids.splice(uids.indexOf(key), 1);
        delete LS_OBJECT.curType;
        delete LS_OBJECT.curId;
        delete LS_OBJECT[key];
        delete LS_OBJECT[type];
		Global.writeLS();
		//登录
		Index.Login.showLogin();
	},

	/**
        @description 判断access_token是否存在
		@return {boolean} true: 存在，false: 不存在
     */
	hasAccessToken: function () {
		return Sina.accessConfig.access_token ? true : false;
	},

	/**
        @description 执行回调函数
		@param {function} callback 回调函数对象
		@param {mix} data 参数值
     */
	execCallback: function(callback, data) {
		if(callback && typeof callback == 'function') {
			callback(data);
		}
	}

};
