// eslint-disable-next-line no-unused-vars
const app = new Vue({
  el: '#app',
  data() {
    return {
      // 语言
      i18n: templateData,
      // 当前页
      pageActive: undefined,
      // 上一页
      pagePrev: undefined,
      pageVerifyPrev: undefined,
      // 标题和说明
      titleText: undefined,
      descText: undefined,
      // 登录方式
      accountType: 'email', // email, mobile
      // 验证码
      sendCodeText: templateData.sendVerifyCode,
      sendCodeDisabled: false,
      sendCodeTimer: false,
      // 获取数据
      browserInfo: {},
      clientData: {},
      accountList: [],
      currentAccount: {},
      localKey: 'accont_options',
      localData: {
        // 账号1: {},
        // 账号2: {}
      },
      // 滚动按钮
      scrollPrevVisible: false,
      scrollNextVisible: false,
      // 提交按钮和信息
      submitBtnText: undefined,
      submitBtnDisabled: false,
      submitCallbackText: undefined,
      // 设置
      settingVisible: false,
      // 选择备用线路
      backupLineVisible: false,
      // 表单：登录时需要提交的内容
      formdata: {
        tempkey: undefined,
        email: undefined,
        mobile: undefined,
        vcode: undefined,
        vcodeId: undefined,
        password: undefined,
        password1: undefined,
        password2: undefined,
        use_backup_line: false,
        remember_password: false,
        auto_login: false,
        delete_profile: false
      },
      // 错误信息
      errorInfo: {
        email: undefined,
        mobile: undefined,
        vcode: undefined,
        password: undefined,
        password1: undefined,
        password2: undefined
      }
    };
  },
  watch: {
    // 切换页面
    'pageActive': function () {
      this.updatePageData();
    },
    // 取消记住密码，必须取消自动登录
    'formdata.remember_password': function (n) {
      if (!n) {
        this.formdata.auto_login = false;
      }
    },
    // 选中自动登录，必须选中记住密码
    'formdata.auto_login': function (n) {
      if (n) {
        this.formdata.remember_password = true;
      }
    }
  },
  created() {
    this.formdata.tempkey = location.search.replace('?tempkey=', '');
    this.initPage();
  },
  mounted() {
    // 初始化电话插件
    this.intlTelInput();
    // 按下Enter键提交
    window.addEventListener('keyup', e => {
      if (e.code === 'Enter' || e.code === 'NumpadEnter') {
        this.handleSubmit();
      }
    });
    // 滚动账号列表时
    const $userList = document.getElementById('userList');
    $userList.addEventListener('scroll', () => {
      this.scrollPrevVisible = $userList.scrollTop > 0;
      this.scrollNextVisible = $userList.scrollTop < $userList.scrollHeight - $userList.offsetHeight;
    });
  },
  methods: {
    // 获取初始化数据
    async initPage() {
      await this.getBrowserInfo();
      await this.getClientData();
      await this.getLocalData();
      this.checkAccountState();
    },
    // 获取浏览器信息
    async getBrowserInfo() {
      this.browserInfo = api.getBrowserInfo();
    },
    // 获取客户端保存的信息
    async getClientData() {
      const res = await api.getClientData();
      const accountList = [];
      res.accounts.forEach(item => {
        if (item.isGuestAccount) {
          accountList.unshift(item);
        } else {
          accountList.push(item);
        }
      });
      this.clientData = res;
      this.accountList = accountList;
      this.scrollNextVisible = accountList.length > 4;
    },
    // 获取本地保存的信息
    async getLocalData() {
      this.localData = await api.getLocalData(this.localKey);
    },
    // 检查账号状态
    async checkAccountState() {
      // 是否需要自动登录
      const currentUser = this.accountList.find(n => n.account === this.clientData.currentAccount);
      if (currentUser?.isAutoLogin) {
        this.handleSelectUser(currentUser);
        this.handleUserLogin();
        return;
      }
      api.openWindow();
      // 区分显示页面
      if (this.accountList.length === 0) {
        // 没有账号：登录页
        this.pageActive = 'login';
      } else if (this.accountList.length === 1) {
        // 一个账号
        if (this.accountList[0].isGuestAccount) {
          // 游客账号：登录页
          this.pageActive = 'login';
        } else if (this.accountList[0].isLocalAccount) {
          // 本地账号：列表页
          this.pageActive = 'userList';
        } else {
          // 登录账号：身份登录页
          this.handleSelectUser(this.accountList[0]);
        }
      } else {
        // 多个账号：列表页
        this.pageActive = 'userList';
      }
    },
    // 获取该模块在此页面下的显示状态
    getVisible(pages) {
      return pages.indexOf(this.pageActive) > -1;
    },
    // 更新页面数据
    updatePageData() {
      // 地址栏路径
      const newUrl = this.pageActive === 'login' ? '/' : this.pageActive;
      window.history.replaceState({}, document.title, newUrl + location.search);
      // 标题/说明/按钮文案
      const str = this.pageActive.replace('Verify', '').replace('Password', '');
      this.titleText = this.i18n[`${str}Title`];
      this.descText = this.i18n[`${str}TitleInfo`];
      this.submitBtnText = this.i18n[`${str}Btn`];
      // 获取焦点
      this.$nextTick(() => {
        $('.mx-input:visible:first').focus();
      });
      // 其它
      switch (this.pageActive) {
        case 'login': // 登录
          this.pagePrev = undefined;
          this.pageVerifyPrev = 'login';
          this.accountType = 'email';
          this.currentAccount.avatarUrl = './img/avatar-login.svg';
          this.handleReset('email,mobile,password,toolbar');
          break;
        case 'userList': // 用户列表
          this.pagePrev = 'login';
          this.accountType = undefined;
          this.currentAccount.avatarUrl = undefined;
          break;
        case 'userLogin': // 用户登录
          this.pagePrev = 'userList';
          this.pageVerifyPrev = 'userLogin';
          this.accountType = undefined;
          this.submitBtnText = this.i18n.loginBtn;
          break;
        case 'registerVerify': // 注册校验
        case 'recoveryVerify': // 找回校验
          this.pagePrev = this.pageVerifyPrev;
          this.accountType = 'email';
          this.currentAccount.avatarUrl = './img/avatar-register.png';
          this.submitBtnText = this.i18n.nextStep;
          this.handleReset('email,mobile,vcode');
          break;
        case 'registerPassword': // 注册提交
        case 'recoveryPassword': // 找回提交
          this.pagePrev = `${str}Verify`;
          this.handleReset('password1,password2');
          break;
        default:
        // ...
      }
    },
    // 初始化电话插件
    intlTelInput() {
      const _this = this;
      $('#mobile').intlTelInput({
        separateDialCode: true,
        initialCountry: 'cn'
      });
      $('.iti input')
        .attr('placeholder', this.i18n.inputMobile)
        .on('input', function () {
          _this.formdata.mobile = $(this).val().trim();
        });
    },
    // 点击关闭
    handleClose() {
      api.closeWindow();
    },
    // 打开设置菜单
    handleOpenSetting() {
      this.settingVisible = true;
      this.$nextTick(() => {
        $('.mx-dropdown:visible').focus();
      });
    },
    // 点击游客登录
    handleLoginTourist() {
      api.useTouristAccount();
    },
    // 选择用户
    async handleSelectUser(selectedAccount) {
      console.log('选择用户', selectedAccount);
      this.currentAccount = selectedAccount;
      if (selectedAccount.isLocalAccount) {
        // 本地账号：直接登录
        api.switchAccount(selectedAccount.profilePath);
      } else {
        // 登录账号
        this.pageActive = 'userLogin';
        // 给表单赋值
        this.formdata.password = this.localData[selectedAccount.account].passwordOrigin || '';
        this.formdata.remember_password = this.currentAccount.isSavePassword;
        this.formdata.auto_login = this.currentAccount.isAutoLogin;
        this.formdata.delete_profile = this.currentAccount.isExitClearData;
      }
    },
    // 点击提交
    handleSubmit() {
      if (this.submitBtnDisabled) {
        return false;
      }
      switch (this.pageActive) {
        case 'login':
          this.handleDefaultLogin();
          break;
        case 'userLogin':
          this.handleUserLogin();
          break;
        case 'userList':
          this.pageActive = 'login';
          break;
        case 'registerVerify':
        case 'recoveryVerify':
          this.handleVerifySubmit();
          break;
        case 'registerPassword':
        case 'recoveryPassword':
          this.handlePasswordSubmit();
          break;
      }
    },
    // 输入账号登录：传输入的账号和密码
    handleDefaultLogin() {
      if (!this.validAccountFormat()) {
        return false;
      }
      if (!this.validPasswordFormat('password')) {
        return false;
      }
      this.handleLoginSubmit({
        account: this.formdata[this.accountType],
        country: $('.iti__selected-dial-code').text().replace('+', '')
      });
    },
    // 选择用户登录
    handleUserLogin() {
      const params = {
        account: this.currentAccount.account,
        country: this.currentAccount.country
      };
      if (this.validPasswordFormat('password')) {
        this.handleLoginSubmit(params);
      }
    },
    // 登录提交
    async handleLoginSubmit({ country, account }) {
      this.submitBtnText = this.i18n.loginLoading;
      this.submitBtnDisabled = true;
      // 服务端登录
      const encodeParams = {
        // 表单信息
        country,
        account,
        password: this.getHashCode(this.formdata.password),
        // 浏览器信息
        ver: this.browserInfo.version,
        os: this.browserInfo.os,
        device: this.browserInfo.device,
        device_name: this.browserInfo.device_name,
        region: this.browserInfo.region,
        language: navigator.language,
        // 固定信息
        type: this.formdata.auto_login ? 'silent' : '',
        app: 'mx3',
        package_id: '',
        product_type: ''
      };
      const encodeResStr = await api.accountLogin(encodeParams, this.formdata.use_backup_line);
      // 登录后通知客户端
      const decodeParams = {
        data: encodeResStr,
        password: this.getHashCode(this.formdata.password),
        remember_password: this.formdata.remember_password,
        auto_login: this.formdata.auto_login,
        delete_profile: this.formdata.delete_profile
      };
      const decodeResObj = await api.clientLogin(decodeParams);
      // 处理登录结果
      this.submitBtnText = this.i18n.loginBtn;
      this.submitBtnDisabled = false;
      if (decodeResObj.code === 0) {
        // 登录成功
        this.saveLocalData(account);
        api.closeWindow();
      } else {
        // 登录失败
        this.backupLineVisible = decodeResObj.code === 201;
        this.errorInfo.password = decodeResObj.msg || decodeResObj.data.msg;
        api.openWindow();
      }
    },
    // 登录成功时保存设置项
    saveLocalData(account) {
      this.localData[account] = {
        passwordOrigin: this.formdata.remember_password ? this.formdata.password : ''
      };
      api.saveLocalData(this.localKey, this.localData);
    },
    // 删除提交
    async handleLogoutSubmit(selectedAccount) {
      api.deleteAccount(selectedAccount.profilePath);
      await this.getClientData();
      if (this.accountList.length === 0) {
        this.pageActive = 'login';
      }
    },
    // 滚动列表
    handleScroll(size) {
      const $userList = $('#userList');
      $userList.animate(
        {
          scrollTop: `${$userList.scrollTop() + size}px`
        },
        100
      );
    },
    // 注册/找回-发送验证码
    sendCode() {
      // 校验
      if (this.sendCodeDisabled) return;
      if (!this.validAccountFormat()) return;
      this.sendCodeDisabled = true;
      // 区分参数
      if (this.pageActive === 'registerVerify') {
        // 注册
        this.formdata.vcodeId = Math.random().toString(36).slice(2) + Date.now().toString(36);
      } else {
        // 找回
        this.formdata.vcodeId = `${this.formdata[this.accountType]}_resetpass`;
      }
      const params = {
        tempkey: this.formdata.tempkey,
        code_id: this.formdata.vcodeId
      };
      if (this.accountType === 'mobile') {
        params.phone = this.formdata.mobile;
        params.country = $('.iti__selected-dial-code').text().replace('+', '');
      } else {
        params.email = this.formdata.email;
      }
      // 提交
      api.sendCode(params).then(res => {
        if (res.code === 0) {
          this.errorInfo.vcode = undefined;
          this.setVcodeTimer();
        } else {
          this.sendCodeDisabled = false;
          this.errorInfo.vcode = res.msg || res.message;
        }
      });
    },
    // 注册/找回-获取验证码-倒计时
    setVcodeTimer() {
      let timeout = 60;
      this.sendCodeTimer = setInterval(() => {
        this.sendCodeText = timeout + this.i18n.verifyCodeTimeout;
        timeout--;
        if (timeout < 0) {
          this.sendCodeText = this.i18n.sendVerifyCode;
          this.sendCodeDisabled = false;
          clearInterval(this.sendCodeTimer);
        }
      }, 1000);
    },
    // 注册/找回-校验验证码
    handleVerifySubmit() {
      // 校验
      if (!this.validAccountFormat()) return;
      if (!this.validVcodeFormat()) return;
      this.submitBtnDisabled = true;
      // 提交
      api
        .verifyCode({
          tempkey: this.formdata.tempkey,
          code: this.formdata.vcode,
          code_id: this.formdata.vcodeId
        })
        .then(res => {
          this.submitBtnDisabled = false;
          if (res.code === 0) {
            this.errorInfo.vcode = undefined;
            this.pageActive = this.pageActive.replace('Verify', 'Password');
          } else {
            this.errorInfo.vcode = res.msg || res.message;
          }
        });
    },
    // 注册/找回-提交
    async handlePasswordSubmit() {
      if (!this.validPasswordFormat('password1')) {
        return false;
      }
      if (this.formdata.password1 !== this.formdata.password2) {
        this.errorInfo.password2 = this.i18n.passwordInconsistency;
        return false;
      }
      this.submitBtnDisabled = true;
      const res = this.pageActive === 'registerPassword' ? await this.registerSubmit() : await this.resetSubmit();
      if (res.code === 0) {
        this.errorInfo.vcode = undefined;
        this.setSuccessTimer();
      } else {
        this.submitBtnDisabled = false;
        this.errorInfo.password2 = res.msg || res.message;
      }
    },
    // 注册提交
    async resetSubmit() {
      const countryCode = $('.iti__selected-dial-code').text().replace('+', '');
      const params = {
        tempkey: this.formdata.tempkey,
        account: this.formdata[this.accountType],
        country: this.accountType === 'mobile' ? countryCode : '',
        password: this.getHashCode(this.formdata.password2)
      };
      return api.registerAccount(params);
    },
    // 找回提交
    async registerSubmit() {
      const params = {
        tempkey: this.formdata.tempkey,
        account: this.formdata[this.accountType],
        code: this.formdata.vcode,
        new_password: this.getHashCode(this.formdata.password2)
      };
      return api.resetPass(params);
    },
    // 注册/找回-成功后跳转-倒计时
    setSuccessTimer() {
      let timeout = 3;
      const key = this.pageActive.replace('Password', 'Success');
      const timer = setInterval(() => {
        this.submitCallbackText = `${this.i18n[key]}(${timeout}s)`;
        timeout--;
        if (timeout < 0) {
          this.pageActive = this.pageVerifyPrev;
          this.submitBtnDisabled = false;
          this.submitCallbackText = undefined;
          clearInterval(timer);
        }
      }, 1000);
    },
    // 校验账号格式
    validAccountFormat() {
      if (this.accountType === 'email') {
        return this.validEmailFormat();
      } else {
        return this.validMobileFormat();
      }
    },
    // 校验邮箱格式
    validEmailFormat() {
      const reg = /^[a-zA-Z0-9+_.-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$/;
      if (reg.test(this.formdata.email)) {
        this.errorInfo.email = undefined;
        return true;
      } else {
        this.errorInfo.email = this.i18n.emailFormatError;
        return false;
      }
    },
    // 校验手机号格式
    validMobileFormat() {
      if (this.formdata.mobile) {
        this.errorInfo.mobile = undefined;
        return true;
      } else {
        this.errorInfo.mobile = this.i18n.mobileEmpty;
        return false;
      }
    },
    // 校验密码格式
    validPasswordFormat(key) {
      const password = this.formdata[key];
      if (password && password.length >= 2 && password.length <= 20) {
        this.errorInfo[key] = undefined;
        return true;
      } else {
        this.errorInfo[key] = this.i18n.passwordLengthError;
        return false;
      }
    },
    // 校验验证码格式
    validVcodeFormat() {
      if (this.formdata.vcode) {
        this.errorInfo.vcode = undefined;
        return true;
      } else {
        this.errorInfo.vcode = this.i18n.enterVerifyCode;
        return false;
      }
    },
    // 重置表单和错误信息
    handleReset(keys) {
      keys.split(',').forEach(key => {
        if (key === 'toolbar') {
          this.formdata.remember_password = false;
          this.formdata.auto_login = false;
          this.formdata.delete_profile = false;
        } else {
          if (key === 'mobile') {
            $('.iti input').val('');
          }
          this.formdata[key] = undefined;
          this.errorInfo[key] = undefined;
        }
      });
    },
    // 获取密码的哈希值
    getHashCode(str) {
      // eslint-disable-next-line no-undef
      return str ? sha256(str) : '';
    }
  }
});
