// preview.js

function preview(obj) {
  const { type, content } = obj;
  const $articleContent = document.querySelector('.articleContent');
  const $snapContent = document.querySelector('.snapContent');
  const $selectContent = document.querySelector('.selectContent');
  for (const elem of [$articleContent, $snapContent, $selectContent]) {
    elem.style.display = 'none';
  }
  if (type === 'web-content') {
    // 正文
    $articleContent.style.display = 'block';
    const $pageContent = $articleContent.querySelector('.page_content');
    if ($pageContent) {
      $pageContent.innerHTML = content;
      replaceImgUrl($pageContent);
      const $articleHeader = $pageContent.querySelector('#articleHeader__separator');
      if ($articleHeader) {
        $articleHeader.classList.add('separator');
      }
    }
  } else if (type === 'snap') {
    // 截图
    $snapContent.style.display = 'block';
    document.querySelector('#snap-image').src = content;
  } else if (type === 'select-content') {
    $selectContent.style.display = 'block';
    const $selectionContent = $selectContent.queryAllSelector('.selectionContent');
    $selectionContent.innerHTML = content;
    replaceImgUrl($selectionContent);
  }
}

// 替换图片地址
function replaceImgUrl($el) {
  const $imgs = $el.querySelectorAll('img');
  console.log($imgs);
  for (let i = 0; i < $imgs.length; i++) {
    $imgs[i].src = $imgs[i].src;
  }
}

// prevent default
function recoverDefault(e) {
  e.preventDefault();
  return false;
}
// window.oncontextmenu = recoverDefault;
window.ondrag = recoverDefault;
window.ondragstart = recoverDefault;
window.ondragend = recoverDefault;
