# Быстрая настройка Linux/OpenWrt

> [!CAUTION]  
> Не пишите в issue вопросы типа "как скопировать файл", "как скачать", "как
> запустить" и т.п. То есть все, что касается базовых навыков обращения с ОС
> Linux. Эти вопросы будут закрывать сразу. Если у вас подобные вопросы
> возникают, рекомендую не использовать данный софт или искать помощь где-то в
> другом месте. То же самое могу сказать тем, кто хочет нажать 1 кнопку, чтобы
> все заработало, и совсем не хочет читать и изучать. Увы, такое не подвезли и
> не подвезут. Ищите другие более простые методы обхода. Этот метод **не для
> рядового пользователя**.


## Вступление
Специально для тех, кто хочет побыстрее начать, но не хочет слишком углубляться
в простыню [readme.md](readme.md).

Обход DPI является хакерской методикой. Под этим словом понимается метод,
которому оказывается активное противодействие и поэтому автоматически не
гарантирована работоспособность в любых условиях и на любых ресурсах, требуется
настройка под специфические условия у вашего провайдера. Условия могут меняться
со временем, и методика может начинать или переставать работать, может
потребоваться повторный анализ ситуации. Могут обнаруживаться отдельные
ресурсы, которые заблокированы иначе, и которые не работают или перестали
работать. Могут и сломаться отдельные не заблокированные ресурсы. Поэтому очень
желательно иметь знания в области сетей, чтобы иметь возможность
проанализировать техническую ситуацию. Не будет лишним иметь обходные каналы
проксирования трафика на случай, если обход DPI не помогает.

Вариант, когда вы нашли стратегию где-то в интернете и пытаетесь ее приспособить к своему случаю - заведомо проблемный.
Нет универсальной таблетки. Везде ситуация разная. В сети гуляют написанные кем-то откровенные глупости, которые тиражируются массово ничего не понимающей публикой.
Такие варианты чаще всего работают нестабильно, только на части ресурсов, только на части провайдеров, не работают вообще или ломают другие ресурсы. В худших случаях еще и устраивают флуд в сети.
Если даже вариант когда-то и работал неплохо, завтра он может перестать, а в сети останется устаревшая информация.

Будем считать, что у вас есть система на базе традиционного **linux** или
**openwrt**. Если у вас традиционный linux - задача обойти блокировки только на
этой системе, если openwrt - обойти блокировки для подключенных устройств. Это
наиболее распространенный случай.


## Настройка
> [!TIP]  
> Чтобы процедура установки сработала в штатном режиме на openwrt, нужно
> рассчитывать на свободное место около 1-2 Mb для установки самого zapret и
> необходимых дополнительных пакетов. Если места мало и нет возможности его
> увеличить за счет `extroot`, возможно придется отказаться от варианта простой
> установки и прикручивать в ручном режиме без имеющихся скриптов запуска.
> Можно использовать [облегченный `tpws` вариант](../init.d/openwrt-minimal),
> либо попробовать засунуть требуемые zapret дополнительные пакеты в сжатый
> образ `squashfs` с помощью `image builder` и перешить этим вариантом роутер.

1. Скачайте последний [tar.gz релиз](https://github.com/bol-van/zapret/releases) в /tmp, распакуйте его, затем удалите архив.
   Для openwrt и прошивок используйте вариант `openwrt-embedded`.
   Для экономия места в /tmp можно качать через curl в stdout и сразу распаковывать.
   Пример под openwrt для версии zapret 71.4 (для других URL отличается) :
   ```
   $ curl -Lo - https://github.com/bol-van/zapret/releases/download/v71.4/zapret-v71.4-openwrt-embedded.tar.gz | tar -zx
   $ wget -O - https://github.com/bol-van/zapret/releases/download/v71.4/zapret-v71.4-openwrt-embedded.tar.gz | tar -zx
   ```
   Пример под традиционный linux для версии zapret 71.4 (для других URL отличается) :
   ```
   $ curl -Lo - https://github.com/bol-van/zapret/releases/download/v71.4/zapret-v71.4.tar.gz | tar -zx
   $ wget -O - https://github.com/bol-van/zapret/releases/download/v71.4/zapret-v71.4.tar.gz | tar -zx
   ```
   curl должен быть предварительно установлен. Но он в любом случае понадобится далее.
   Вариант с wget будет работать только если установленный wget поддерживает https.

2. Убедитесь, что у вас отключены все средства обхода блокировок, в том числе и
   сам zapret. Гарантированно уберет zapret скрипт `uninstall_easy.sh`.

3. Если вы работаете в виртуальной машине, необходимо использовать соединение с
   сетью в режиме bridge. NAT **не** подходит.

4. Выполните однократные действия по установке требуемых пакетов в ОС и
   настройке исполняемых файлов правильной архитектуры:
   ```sh
   $ install_bin.sh
   $ install_prereq.sh
   ```

   > Вас могут спросить о типе фаервола (iptables/nftables) и использовании
   > ipv6. Это нужно для установки правильных пакетов в ОС, чтобы не
   > устанавливать лишнее.

5. Запустите `blockcheck.sh`. Скрипт вначале проверяет DNS. Если выводятся
   сообщения о подмене адресов, то нужно будет решить проблему с DNS.
   `blockcheck.sh` перейдет в этом случае на DoH и будет пытаться получить и
   использовать реальные IP адреса. Но если вы не настроите решение этой
   проблемы, обход будет работать только для тех программ или ОС, которые сами
   реализуют механизмы SecureDNS. Для других программ обход работать не будет.

   > Решение проблемы DNS выходит за рамки проекта. Обычно она решается либо
   > заменой DNS серверов от провайдера на публичные (`1.1.1.1`, `8.8.8.8`),
   > либо в случае перехвата провайдером обращений к сторонним серверам - через
   > специальные средства шифрования DNS запросов, такие как `dnscrypt`, `DoT`,
   > `DoH`.
   >
   > Еще один эффективный вариант - использовать ресолвер от yandex
   > (`77.88.8.88`) на нестандартном порту `1253`. Многие провайдеры не
   > анализируют обращения к DNS на нестандартных портах.
   >
   > Проверить работает ли этот вариант можно так:
   > ```sh
   > $ dig -p 53 @77.88.8.88 rutracker.org
   > $ dig -p 1253 @77.88.8.88 rutracker.org
   > ```
   >
   > Если DNS действительно подменяется, и ответ на эти 2 команды разный,
   > значит метод вероятно работает.
   >
   > В openwrt DNS на нестандартном порту можно прописать в `/etc/config/dhcp`
   > таким способом:
   >
   > ```
   > config dnsmasq
   > 	<...>
   > 	list server '77.88.8.88#1253'
   > ```
   >
   > Если настройки IP и DNS получаются автоматически от провайдера, в
   > `/etc/config/network` найдите секцию интерфейса `wan` и сделайте так:
   >
   > ```
   > config interface 'wan'
   > 	<...>
   > 	option peerdns '0'
   > ```
   >
   > ```sh
   > $ /etc/init.d/network restart
   > $ /etc/init.d/dnsmasq restart
   > ```
   >
   > Если это не подходит, можно перенаправлять обращения на UDP и TCP порты
   > `53` вашего DNS сервера на `77.88.8.88:1253` средствами
   > `iptables`/`nftables`. В `/etc/resolv.conf` нельзя прописать DNS на
   > нестандартном порту.

6. `blockcheck.sh` позволяет выявить рабочую стратегию обхода блокировок. По
   результатам скрипта нужно понять какой вариант будете использовать : `nfqws`
   или `tpws` и запомнить найденные стратегии для дальнейшего применения.

   Следует понимать, что скрипт проверяет доступность только конкретного
   домена, который вы вводите в начале, конкретной программой curl.
   У разных клиентов есть свой фингерпринт. У броузеров один, у curl другой.
   Может применяться или не применяться многопакетный TLS с постквантовой криптографией (kyber).
   От этого может зависеть работоспособность стратегий.
   Обычно остальные домены блокированы подобным образом, **но не факт**.
   Бывают специальные блокировки. Некоторые параметры требуют тюнинга под "общий знаменатель".
   В большинстве случаев можно объединить несколько стратегий в одну универсальную, и это **крайне
   желательно**, но это требует понимания как работают стратегии. zapret **не может
   пробить блокировку по IP адресу**. Для проверки нескольких доменов вводите
   их через пробел.

   > Сейчас блокираторы ставят на магистральных каналах. В сложных случаях у
   > вас может быть несколько маршрутов с различной длиной по ХОПам, с DPI на
   > разных хопах. Приходится преодолевать целый зоопарк DPI, которые еще и
   > включаются в работу хаотичным образом или образом, зависящим от
   > направления (IP сервера). скрипт не всегда может выдать вам в итогах
   > оптимальную стратегию, которую надо просто переписать в настройки. В
   > некоторых случаях надо реально думать что происходит, анализируя результат
   > на разных стратегиях.
   >
   > Далее, имея понимание что работает на http, https, quic нужно
   > сконструировать параметры запуска `tpws` и/или `nfqws` с использованием
   > мультистратегии. Как работают мультистратегии описано в [readme.md](./readme.md#множественные-стратегии).
   >
   > Если кратко, то обычно параметры конструируются так:
   > ```sh
   > "--filter-udp=443 'параметры для quic' <HOSTLIST_NOAUTO> --new
   > --filter-tcp=80,443 'объединенные параметры для http и https' <HOSTLIST>"
   > ```
   >
   > Или так:
   > ```sh
   > "--filter-udp=443 'параметры для quic' <HOSTLIST_NOAUTO> --new
   > --filter-tcp=80 'параметры для http' <HOSTLIST> --new
   > --filter-tcp=443 'параметры для https' <HOSTLIST>"
   > ```
   >
   > `<HOSTLIST>` и `<HOSTLIST_NOAUTO>` так и пишутся. Их не надо на что-то
   > заменять. Это сделают скрипты запуска, если вы выбрали режим фильтрации по
   > хостлистам, и уберут в противном случае. Если для какого-то протокола надо
   > дурить все без стандартного хостлиста - просто уберите оттуда `<HOSTLIST>`
   > и `<HOSTLIST_NOAUTO>`. Можно писать свои параметры `--hostlist` и
   > `--hostlist-exclude` для дополнительных хостлистов или в профилях
   > специализаций под конкретный ресурс. В последнем случае стандартный
   > хостлист там не нужен. Следует избегать указания собственных параметров
   > `--hostlist` на листы из директории ipset. Эта логика включена в
   > `<HOSTLIST>` и `<HOSTLIST_NOAUTO>`. Отличие `<HOSTLIST_NOAUTO>` в том, что
   > стандартный автолист по этому профилю используется как обычный, то есть
   > без автоматического добавления доменов. Однако, добавления в других
   > профилях автоматически отражаются во всех остальных.
   >
   > Если стратегии отличаются по версии ip протокола, и вы не можете их
   > обьединить, фильтр пишется так:
   > ```sh
   > "--filter-l3=ipv4 --filter-udp=443 lпараметры для quic ipv4' <HOSTLIST_NOAUTO> --new
   > --filter-l3=ipv4 --filter-tcp=80 'параметры для http ipv4' <HOSTLIST> --new
   > --filter-l3=ipv4 --filter-tcp=443 'параметры для https ipv4' <HOSTLIST> --new
   > --filter-l3=ipv6 --filter-udp=443 'параметры для quic ipv6' <HOSTLIST_NOAUTO> --new
   > --filter-l3=ipv6 --filter-tcp=80 'параметры для http ipv6' <HOSTLIST> --new
   > --filter-l3=ipv6 --filter-tcp=443 'параметры для https ipv6' <HOSTLIST>"
   > ```
   >
   > Но здесь совсем "копи-пастный" вариант. Чем больше вы объедините стратегий и
   > сократите их общее количество, тем будет лучше.
   >
   > Если вам не нужно дурение отдельных протоколов, лучше всего будет убрать
   > лишние порты из системы перехвата трафика через параметры `TPWS_PORTS`,
   > `NFQWS_PORTS_TCP`, `NFQWS_PORTS_UDP` и убрать соответствующие им профили
   > мультистратегии.
   >
   > | Протокол | Порт | Примечание |
   > |---|---|---|
   > | `tcp` | `80` | `http` соединение |
   > | `tcp` | `443` | `https` соединение |
   > | `udp` | `443` | `quic` соединение |
   >
   > Если используются методы нулевой фазы десинхронизации (`--mss`,
   > `--wssize`, `--dpi-desync=syndata`) и режим фильтрации `hostlist`, то все
   > параметры, относящиеся к этим методам, следует помещать в отдельные
   > профили мультистратегии, которые получат управление до определения имени
   > хоста. Необходимо понимать алгоритм работы мультистратегий. Самым надежным
   > вариантом будет дублирование этих параметров на 2 профиля. Какой-нибудь
   > сработает в зависимости от параметра `MODE_FILTER`.
   >
   > ```sh
   > "--filter-tcp=80 'параметры для http' <HOSTLIST> --new
   > --filter-tcp=443 'параметры для https' --wssize 1:6 <HOSTLIST> --new
   > --filter-tcp=443 --wssize 1:6"
   > ```
   >
   > В этом примере `wssize` будет применяться всегда к порту tcp `443` вне
   > зависимости от параметра `MODE_FILTER`. Хостлист будет игнорироваться,
   > если таковой имеется. К http применять `wssize` вредно и бессмысленно.
   >
   > Иногда требуется дописать к стратегиям свои собственные параметры.
   > Например, нужно изменить количество повторов фейков или задать свой фейк.
   > Это делается через шелл-переменные `PKTWS_EXTRA`, `TPWS_EXTRA`.
   >
   > ```PKTWS_EXTRA="--dpi-desync-repeats=10 --dpi-desync-fake-tls=/tmp/tls.bin" ./blockcheck.sh```
   >
   > Перебор всех комбинаций может привести к ожиданию неделями, поэтому выбран разумный
   > костяк проверки, на который вы можете навешивать свои кустомизации.

7. Запустите скрипт облегченной установки - `install_easy.sh` Выберите `nfqws`
   и/или `tpws`, затем согласитесь на редактирование параметров. Откроется
   редактор, куда впишите созданную на предыдущем этапе стратегию.

8. На все остальные вопросы `install_easy.sh` отвечайте согласно выводимой
   аннотации.

9. Удалите директорию из /tmp, откуда производилась установка.

## Полное удаление

1. Прогоните `/opt/zapret/uninstall_easy.sh`.
2. Cогласитесь на удаление зависимостей в openwrt.
3. Удалите каталог `/opt/zapret`.

## Итог
Это минимальная инструкция, чтобы быстро сориентироваться с чего начать.
Однако, это не гарантированное решение и в некоторых случаях вы не обойдетесь
без знаний и основного "талмуда". Подробности и полное техническое описание
расписаны в [README](readme.md).

Если ломаются отдельные **не заблокированные** ресурсы, следует вносить их в
исключения, либо пользоваться ограничивающим `ipset` или хост листом. Лучше
подбирать такие стратегии, которые вызывают минимальные поломки. Есть стратегии
довольно безобидные, а есть сильно ломающие, которые подходят только для
точечного пробития отдельных ресурсов, когда ничего лучше нет. Хорошая
стратегия может сильно ломать из-за плохо подобранных ограничителей для фейков
\- ttl, fooling.
